﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Graphic.Sample3
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr GetDC(IntPtr hWnd);

        [DllImport("gdi32.dll")]
        public static extern bool MoveToEx(IntPtr hDC, int x, int y, IntPtr lpPoint);

        [DllImport("gdi32.dll")]
        public static extern bool Ellipse(IntPtr hDC, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);

        [DllImport("gdi32.dll")]
        public static extern bool PolyBezier(IntPtr hDC, Point[] lpPoints, int pointsCount);

        [DllImport("gdi32.dll")]
        public static extern bool Polygon(IntPtr hDC, Point[] lpPoints, int pointsCount);

        [DllImport("gdi32.dll")]
        public static extern bool Polyline(IntPtr hDC, Point[] lpPoints, int pointsCount);

        [DllImport("gdi32.dll")]
        public static extern bool PolylineTo(IntPtr hDC, Point[] lpPoints, int pointsCount);

        [DllImport("gdi32.dll")]
        public static extern bool PolyPolyline(IntPtr hDC, Point[] lpPoints, int[] lpdwPolyPoints, int ppCount);

        [DllImport("gdi32.dll")]
        public static extern bool Pie(IntPtr hDC, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nXRadial1, int nYRadial1, int nXRadial2, int nYRadial2);

        [DllImport("gdi32.dll")]
        public static extern bool PolyPolygon(IntPtr hDC, Point[] lpPoints, int[] lpdwPolyPoints, int ppCount);

        [DllImport("gdi32.dll")]
        public static extern bool RoundRect(IntPtr hDC, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nWidth, int nHeight);

        [DllImport("gdi32.dll")]
        public static extern bool Rectangle(IntPtr hDC, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);

        private IntPtr panelHDC;

        public IntPtr PanelHDC
        {
            get
            {
                if (panelHDC == IntPtr.Zero)
                    panelHDC = GetDC(panelDraw.Handle);
                return panelHDC;
            }
        }

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonPolylineTo_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            MoveToEx(PanelHDC, 10, 10, IntPtr.Zero);
            Point[] linePoins = new Point[] { new Point(100, 10), new Point(10, 10), new Point(10, 100), new Point(100, 100), new Point(100, 200), new Point(10, 200) };
            PolylineTo(PanelHDC, linePoins, linePoins.Length);
        }

        private void buttonPolyBezier_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            MoveToEx(PanelHDC, 10, 10, IntPtr.Zero);
            Point[] linePoins = new Point[] { new Point(10, 70), new Point(150, 100), new Point(200, 159), new Point(200, 200), new Point(300, 100), new Point(100, 45), new Point(10, 50) };
            PolyBezier(PanelHDC, linePoins, linePoins.Length);
        }

        private void buttonPolygon_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            Point[] linePoins = new Point[] { new Point(75, 0), new Point(111, 150), new Point(0, 50), new Point(150, 50), new Point(32, 150) };
            Polygon(PanelHDC, linePoins, linePoins.Length);
        }

        private void buttonPolyPolyline_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            Point[] points = new Point[] { new Point(100, 100), new Point(200, 100), new Point(200, 200), new Point(100, 200), new Point(100, 100), new Point(10, 10), new Point(100, 10), new Point(10, 200), new Point(10, 10) };
            int[] polyCount = new[] { 5, 4 };
            PolyPolyline(PanelHDC, points, polyCount, polyCount.Length);
        }

        private void buttonPolyPolygon_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            Point[] points = new Point[] { new Point(10, 10), new Point(100, 10), new Point(100, 200), new Point(10, 10), new Point(20, 20)
            , new Point(50, 100), new Point(150, 100)};
            int[] polyCount = new[] { 4, 3 };
            PolyPolygon(PanelHDC, points, polyCount, polyCount.Length);
        }

        private void buttonPie_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            Pie(PanelHDC, 10, 10, 100, 50, 150, 150, 20, 20);
            Pie(PanelHDC, 100, 100, 200, 200, 100, 100, 200, 100);
        }

        private void buttonEllipse_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            Ellipse(PanelHDC, 50, 50, 280, 200);
        }

        private void buttonRectangle_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            Rectangle(PanelHDC, 50, 50, 280, 200);
        }

        private void buttonRoundRect_Click(object sender, EventArgs e)
        {
            panelDraw.Refresh();
            RoundRect(PanelHDC, 50, 50, 290, 180, 20, 20);
        }
    }
}